﻿const float MAXVAL = 10.0;

float fitClamped(float value, float inMin, float inMax, float outMin, float outMax){
	float outVal = (outMax - outMin) * (value - inMin) / (inMax - inMin) + outMin;
	outVal = clamp(outVal, outMin, outMax);
	return outVal;
}

vec2 getNNGridTextureSpacePosition(vec3 position, vec3 refOrigin, vec3 refSize, int cubeResolution, int texRes){
	vec3 pos;
	pos.x = fitClamped(position.x, refOrigin.x, refOrigin.x+refSize.x, 0, 1.0);
	pos.y = fitClamped(position.y, refOrigin.y, refOrigin.y+refSize.y, 0, 1.0);
	pos.z = fitClamped(position.z, refOrigin.z, refOrigin.z+refSize.z, 0, 1.0);
	

	int xCell = int(floor(pos.x * (cubeResolution)));
	int yCell = int(floor(pos.y * (cubeResolution)));
	int zCell = int(floor(pos.z * (cubeResolution)));

	int linearIndex = ((zCell * cubeResolution + yCell) * cubeResolution) + xCell;
	int texY = linearIndex / texRes;
	int texX = linearIndex - texY * texRes;

	vec2 renderCoords = vec2(float(texX), float(texY));
	renderCoords += vec2(0.5);
	renderCoords /= float(texRes);
	renderCoords = renderCoords * 2.0 - vec2(1.0);

	return renderCoords;
}

vec2 getNNGridTexCoords(vec3 position, vec3 refOrigin, vec3 refSize, int cubeResolution, int texRes){
	vec2 renderPos = getNNGridTextureSpacePosition(position, refOrigin, refSize, cubeResolution, texRes);
	return renderPos / 2.0 + vec2(0.5);
}

vec2 getPhysTextureSpacePosition(int vertIndex, int texRes){
	int xCoord = int(mod(vertIndex, texRes));
	int yCoord = (vertIndex - xCoord) / (texRes);

	vec2 texCoord = vec2(float(xCoord)+0.5, float(yCoord)+0.5);
	return texCoord / float(texRes);
}