#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
	vec2 uv_distorted;
	vec4 clipSpace;
	vec3 toCameraVector; 
} vert;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;
uniform vec4 plane;
uniform vec3 cameraPos;

const float tiling = 2.0;

void main() {
	vert.normal_world = normalMatrix * normal;
	vert.uv = uv * tiling;
	vec4 position_world_ = modelMatrix * vec4(position, 1);
	vert.position_world = position_world_.xyz;

	gl_ClipDistance[0] = dot(position_world_, plane); //distance from vertex to plane
	vert.clipSpace = viewProjMatrix * position_world_;
	gl_Position = vert.clipSpace;
	vert.uv_distorted = vec2(position.x/2.0 + 0.5, position.y/2.0 + 0.5) * 3 * tiling;
	vert.toCameraVector = cameraPos - vert.position_world;

}