#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

in VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

layout (location = 0) out vec4 color;
layout (location = 1) out vec4 brightness;
 
const vec3 lightColor = vec3(1, 0, 0);

void main() {	
	color = vec4(lightColor, 1);
	float bright = dot(color.rgb, vec3(0.2126, 0.7152, 0.0722));
    if (bright > 1.0) {
        brightness = vec4(color.rgb, 1);
	} else {
        brightness = vec4(0.0, 0.0, 0.0, 1.0);
	}
}

