#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

in VertexData {
	vec2 uv;
} vert;

out vec4 color;

uniform vec3 materialCoefficients; // x = ambient, y = diffuse, z = specular 
uniform float specularAlpha;

uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform bool bloom;
uniform float exposure;

vec3 phong(vec3 n, vec3 l, vec3 v, vec3 diffuseC, float diffuseF, vec3 specularC, float specularF, float alpha, bool attenuate, vec3 attenuation) {
	float d = length(l);
	l = normalize(l);
	float att = 1.0;	
	if(attenuate) att = 1.0f / (attenuation.x + d * attenuation.y + d * d * attenuation.z);
	vec3 r = reflect(-l, n);
	return (diffuseF * diffuseC * max(0, dot(n, l)) + specularF * specularC * pow(max(0, dot(r, v)), alpha)) * att; 
}

void main() {	

	const float gamma = 1.8;
    vec3 hdrColor = texture(sceneTexture, vert.uv).rgb;      
    vec3 bloomColor = texture(blurTexture, vert.uv).rgb;
    if(bloom) {
        hdrColor += bloomColor; // additive blending
	}

    vec3 result = vec3(1.0) - exp(-hdrColor * exposure);
     
    result = pow(result, vec3(1.0 / gamma));
    color = vec4(result, 1.0);
}


