#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

in VertexData {
	vec2 uv;
} vert;

out vec4 color;


uniform sampler2D sceneTexture;
uniform bool horizontal;
uniform float weight[5] = float[] (0.2270270270, 0.1945945946, 0.1216216216, 0.0540540541, 0.0162162162);


void main() {	

	
	vec2 texOffset = 1.0 / textureSize(sceneTexture, 0);
	vec3 fragColor = texture(sceneTexture, vert.uv).rgb*weight[0];

	if (horizontal) {
         for (int i = 1; i < 5; ++i) {
            fragColor += texture(sceneTexture, vert.uv + vec2(texOffset.x * i, 0.0)).rgb * weight[i];
            fragColor += texture(sceneTexture, vert.uv - vec2(texOffset.x * i, 0.0)).rgb * weight[i];
         }
     } else { // vertical blur
         for(int i = 1; i < 5; ++i) {
             fragColor += texture(sceneTexture, vert.uv + vec2(0.0, texOffset.y * i)).rgb * weight[i];
             fragColor += texture(sceneTexture, vert.uv - vec2(0.0, texOffset.y * i)).rgb * weight[i];
         }
     }
	 color = vec4(fragColor, 1.0);
}
