#version 430 core
/*
* Copyright 2010 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

in VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

layout (location = 0) out vec4 color;
layout (location = 1) out vec4 brightness;
 
uniform vec3 camera_world;

uniform vec3 materialCoefficients; // x = ambient, y = diffuse, z = specular 
uniform float specularAlpha;

uniform struct DirectionalLight {
	vec3 color;
	vec3 direction;
} dirL;

uniform struct PointLight {
	vec3 color;
	vec3 position;
	vec3 attenuation;
} pointL;

uniform vec3 glowColor;


void main() {	
	color = vec4(glowColor, 1);

	float bright = dot(color.xyz, vec3(0.0, 1.1, 0.0));
    if (bright > 1.0f) {
        brightness = vec4(color.xyz, 1);
	} else {
        brightness = vec4(0.0, 0.0, 0.0, 1.0);
	}
}

