#version 330
 
in vec3 position;
in vec3 normal;
in vec3 color;
in vec2 uv;

uniform mat4 model;
uniform mat4 view_project;
uniform int lightNr;
uniform vec3 lights[20];
 
out vec3 worldNormal;
out vec2 fragmentUV;
out vec3 eye;
out vec3 lightDir[20];
out vec3 colorOut;

flat out int lightNumber;
 
void main () {
	vec4 pos = model * vec4(position,1);
	fragmentUV = uv;
	worldNormal = (model * vec4(normal, 0)).xyz;
	lightNumber = lightNr;

	for(int i = 0; i < lightNr; i++){
		lightDir[i] = vec3(lights[i])-vec3(pos);
	}

	eye = vec3(-pos);
	colorOut = color;

	gl_Position = view_project * model * vec4(position,1); 
}