#version 430 core

flat in int lightNumber;

in vec3 worldNormal;
in vec2 fragmentUV;
in vec3 eye;
in vec3 lightDir[20];
in vec3 colorOut;

uniform vec4 ambient;
uniform vec4 specular;
uniform float shininess;
uniform int laserIsActive;
uniform sampler2D colorTexture;

layout(location = 0) out vec4 fragColor;

void main(){

	vec4 spec = vec4(0.0);
	vec3 textureColor1 = texture(colorTexture, fragmentUV).rgb;
	vec4 tc1 = vec4(textureColor1,1);
	
	if(laserIsActive == 1){
		vec3 n = normalize(worldNormal);
		vec3 e = normalize(eye);

		vec4 result;
		float intensities;

		for(int i = 0; i < lightNumber; i++) {
			vec3 l = normalize(lightDir[i]);
			float intensity = max(dot(n,l), 0.0);

			if (intensity > 0.0) {
				vec3 h = normalize(l + e);
				float intSpec = max(dot(h,n), 0.0);
				spec = specular * pow(intSpec, shininess);
				result += spec;
				intensities += intensity;
			}
		}

		if(intensities > 0.6){
			fragColor = result + vec4(mix(textureColor1, vec3(1.0f, 0.0f, 0.0f),0.2f), 1.0f);
		} else {
			fragColor = tc1;
		}

	} else {
		fragColor = tc1;
	}
}