#version 330 core
//https://thebookofshaders.com/13/

in vec4 v_texCoord4D;
in vec3 TexCoords;

uniform float time;
uniform float percent;

out vec4 color;

float hash(float n) { 
	return fract(sin(n) * 1e4);
}

float hash(vec2 p) {
	return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x))));
}

float noise(vec3 x) {
    const vec3 step = vec3(110, 241, 171);

    vec3 i = floor(x);
    vec3 f = fract(x);
 
    // For performance, compute the base input to a 1D hash from the integer part of the argument and the 
    // incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

    vec3 u = f * f * (3.0 - 2.0 * f);
    return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define NUM_OCTAVES 6

float fbm(vec3 x) {
	float v = 0.0;
	float a = 0.5;
	vec3 shift = vec3(0.0);
	for (int i = 0; i < NUM_OCTAVES; ++i) {
		v += a * noise(x);
		x = x * 2.0 + shift;
		a *= 0.5;
	}
	return v;
}

void main()
{
	vec3 st = v_texCoord4D.xyz;
	//st.y = st.y + time * 0.15;
    //st += st * abs(sin(time*0.1)*3.0);
    vec3 colors = vec3(0.0);

    vec3 q = vec3(0.0);
    q.x = fbm( vec3(st.xyz) + vec3(1.0));
    q.y = fbm( vec3(st.xyz) + vec3(1.0));
	q.z = fbm( vec3(st.xyz) + vec3(1.0));

    vec3 r = vec3(0.);
    r.x = fbm( st.xyz + 1.0*q.xyz + vec3(1.7,9.2,9.0)+ 0.15*time);
    r.y = fbm( st.xyz + 1.0*q.xyz + vec3(8.3,2.8,9.0)+ 0.126*time);
	r.z = fbm( st.xyz + 1.0*q.xyz + vec3(1.7,9.2,9.0)+ 0.125*time);

    float f = fbm(st.xyz+r.xyz);

	colors = mix(vec3(0.101961,0.619608,0.666667),
                vec3(0.666667,0.666667,0.498039),
                clamp((f*f)*4.0,0.0,1.0));

    colors = mix(colors,
                vec3(0,0,0.164706),
                clamp(length(q.xyz),0.0,1.0));

    colors = mix(colors,
                vec3(0.2,0.666667,1),
                clamp(length(r.x),0.0,1.0));

	float x = (f*f*f+.6*f*f+.5*f);

	float g = pow(x,2.5);
    color = vec4(colors,pow(x,2.5)) * percent;
	//color = vec4(t,1);

}