#version 330 core
// https://developer.nvidia.com/gpugems/GPUGems3/gpugems3_ch27.html

layout (location = 0) out vec4 FragColor;

in vec2 TexCoords;

uniform int numSamples;
uniform float strength;
uniform sampler2D Depth;
uniform sampler2D Scene;
uniform sampler2D Mask;

uniform mat4 viewProjectInverse;
uniform mat4 prevViewProject;

void main()
{             
	int samples = numSamples;
	float zOverW = texture(Depth, TexCoords).r;
	vec4 H = vec4(TexCoords.x * 2 - 1, TexCoords.y * 2 - 1, zOverW * 2 - 1, 1);

	//vec4 D = H * viewProjectInverse;
	vec4 D = viewProjectInverse * H;

	vec4 worldPos = D;// / D.w;

	vec4 currentPos = H;
	//vec4 previousPos = worldPos * prevViewProject;
	vec4 previousPos = prevViewProject * worldPos;
	previousPos = previousPos / previousPos.w;
	//previousPos.xy = previousPos.xy * 0.5 + 0.5;
	vec2 velocity = (currentPos.xy - previousPos.xy)/2 * strength;
	//velocity *= -1;

	//vec4 result = texture(Scene, TexCoords);
	vec4 result = vec4(0);
	/*
	if(texture(Mask, TexCoords).g == 0.0){
		result = texture(Scene, TexCoords);
	} else {
		//samples = samples - 1;
	}
	*/

	vec2 texcoord = TexCoords;
	for (int i = 0; i < numSamples; i++, texcoord += velocity / numSamples) {
		bool mask = (texture(Mask, texcoord).g > 0.0) || (texture(Mask, TexCoords).g > 0.0);
		if (mask) {
			result += texture(Scene, TexCoords);
		} else {
			result += texture(Scene, texcoord);
		}
	}
	result /= numSamples;

	/*
	texcoord += velocity;
	for (int i = 1; i < numSamples; ++i, texcoord += velocity) {
		vec2 offset = velocity * (float(i) / float(numSamples));
		
		if((texture(Mask, TexCoords + offset).g == 0.0) && (texture(Mask, TexCoords).g == 0.0)){
			result += texture(Scene, TexCoords + offset);
		} else {
			//samples = samples - 1;
			result += texture(Scene, TexCoords);
		}
	}

	result /= float(samples);	
	*/
 

	//Depth: first value (r) is Depth, second value (g) true if lightcycle, otherwise false
	
	FragColor = result;
	/*
	if(texture(Mask, TexCoords).g == 1.0) {
		FragColor = texture(Scene, TexCoords).rgba;
	} else {
		FragColor = result;
	}*/

	if (false) {	
		if (velocity.x < 0) { velocity.x = -velocity.x; }
		if (velocity.y < 0) { velocity.y = -velocity.y; }

		FragColor = vec4(velocity * 10, 0, 1);
		if(texture(Mask, TexCoords).g == 1.0) {
			FragColor = vec4(0,0,1,1);
			FragColor = texture(Scene, TexCoords);
		}
	}

	if (false) {
		FragColor = texture(Mask, TexCoords);
	}

	if (false) {
		float z_b = texture(Depth, TexCoords).x;
		
		float near = 0.2;
		float far = 100;
		float z_e = (2.0 * near) / (far + near - z_b * (far - near));
		// z_b = ((-2.0 * near / z_e) + far + near) / (far - near);
		// z_e = (2.0 * near) / (far + near - z_b * (far - near));


		FragColor = vec4(z_e);
		if (texture(Depth, TexCoords).r >= 1) {
			FragColor = vec4(0,0,1,1);
		}
	}
}