#version 330 core

uniform float time;

in vec3 position;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

out vec4 v_texCoord4D;
out float height;
out vec3 coord;

void main( void )
{
    float radiansTime = time * 3.141592654 * 0.01; //animation faster/slower
	radiansTime = 5.5;
	vec3 texCoordVarying = position.xyz*0.1 + vec3(0.0 + sin(1.0 + radiansTime * 1.0) * 0.2, 0.0 + sin(1.9 + radiansTime * 8.0) * 0.4, 0.0 + sin(1.4 + radiansTime * 5.0) * 0.3)*2;
    v_texCoord4D = vec4(texCoordVarying.xyz * 1.6, time*1.5);

	gl_Position = projection * view * model * vec4(position, 1.0);
	height = vec3(model * vec4(position, 1.0)).y;
	coord = position;
	//coord = vec2(vec3(model * vec4(position, 1.0)).x, vec3(model * vec4(position, 1.0)).z);
}