#version 330 core
//https://thebookofshaders.com/13/

layout (location = 2) out vec4 MaskTrail;

in vec4 v_texCoord4D;
uniform float trailheight;
uniform vec3 tireCoord;
uniform vec3 colorChange;
uniform float threshold;
uniform bool reverse;
uniform sampler2D Mask;
uniform mat4 projection;
uniform mat4 view;

out vec4 color;
out float gl_FragDepth;

in float height;
in vec3 coord;

float calcDist() {
	return distance(coord, tireCoord);
}

int inCircle(float dist, float radius) {
	if (dist < radius) {
		return 1;
	}
	else if (dist < radius + threshold) {
		return 2;
	}
	return 0;
}

float calcAdditionalBrightness(float radius, float dist) {
	float diff = dist - radius;
	diff = diff / threshold;
	return (1 - diff ) * 0.6;
}

void main()
{
	float heightpercent = ((height / trailheight) * 2) - 1;
	color = vec4(colorChange, heightpercent * heightpercent);
	
	float dist = calcDist();
	float radius = trailheight / 2;
	
	float circle = inCircle(dist, radius);
	if ((coord.x > tireCoord.x && !reverse) || (coord.x < tireCoord.x && reverse) || circle == 1) {
		//MaskTrail = vec4(0,0,0,1);
		discard;
		//color.a = 0;
	} else if (circle == 2) {
		color.a += calcAdditionalBrightness(radius, dist);
		if (color.a > 1) {
			color.a = 1;
		}
	}

	MaskTrail = vec4(0,1,0,1);
}