/*#version 330 core
layout (location = 0) in vec3 position;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

uniform float phase;

out vec2 texCoordVarying1, texCoordVarying2, texCoordVarying3;
out vec3 TexCoords;

void main()
{
    gl_Position =   projection * view * model * vec4(position, 1.0);  
    TexCoords = position;
}  */

#version 330 core


//layout (location = 0) in vec3 position;
uniform float phase;

layout (location = 0) in vec3 position;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

out vec2 texCoordVarying1;
out vec2 texCoordVarying2;
out vec2 texCoordVarying3;
//out vec3 texCoord;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main()
{ 
    float radiansTime = phase * 3.141592654 * 1.9; //animation faster/slower

	texCoordVarying1 = position.xy*0.1 + vec2(0.0 + sin(1.0 + radiansTime * 1.0) * 0.2, 0.0 + sin(1.9 + radiansTime * 8.0) * 0.4)*2;
    texCoordVarying2 = position.xy*0.1 + vec2(0.9 - sin(0.8 + radiansTime * 2.0) * 0.2, 0.6 - sin(1.3 + radiansTime * 3.0) * 0.8)*2;
    texCoordVarying3 = position.xy*0.1 + vec2(0.9 + sin(0.7 + radiansTime * 5.0) * 0.2, 0.5 + sin(0.2 + radiansTime * 9.0) * 0.1)*2;
	
    gl_Position =   projection * view * model * vec4(position, 1.0);
}