#version 330 core
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;
layout (location = 2) out vec4 Depth;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fs_in;
flat in int lightNumber;
in float depthVS;

uniform vec3 lightColor;
uniform bool spaceshipLight;

void main()
{          
	FragColor = vec4(1,0,0,1); 
    FragColor = vec4(lightColor + 0*fs_in.Normal + 0*lightNumber, 1.0);
    float brightness = dot(FragColor.rgb, vec3(0.2126, 0.7152, 0.0722));
    if(brightness > 1.0) {
        BrightColor = vec4(FragColor.rgb, 1.0);
		//BrightColor = vec4(0,1,0,1);
	} else {
		BrightColor = vec4(0,0,0,1);
	}

	if (spaceshipLight) {
		Depth = vec4((1-depthVS*0.01), 1.0, 1.0, 1.0f);
	} else {
		Depth = vec4((1-depthVS*0.01), 0.0, 0.0, 1.0f);
	}
}