#version 430

in vec3 position;
in vec3 normal;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
} vs_out;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform mat4 model2;

out vec4 v_texCoord4D;

void main( void )
{
	float time = 0;
    float radiansTime = 5.5;
	gl_Position = projection * view * model * vec4(position, 1.0);	
	vec3 texCoordVarying = gl_Position.xyz*0.1 + vec3(0.0 + sin(1.0 + radiansTime * 1.0) * 0.2, 0.0 + sin(1.9 + radiansTime * 8.0) * 0.4, 0.0 + sin(1.4 + radiansTime * 5.0) * 0.3)*2;
    v_texCoord4D = vec4(texCoordVarying.xyz * 0.6, time*2.1);
    v_texCoord4D = vec4((model * vec4(position, 1.0)).xyz, time*2.1);

	vs_out.FragPos = vec3(model * vec4(position, 1.0)); 
	vs_out.Normal = vec3(0,1,0);
}