#version 330 core

in vec4 v_texCoord4D;

layout(location = 0) out vec4 color;
layout (location = 2) out vec4 Mask;


in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
} fs_in;

struct Light {
    vec3 Position;
    vec3 Color;
	vec3 Direction;
};

uniform Light light[4];
uniform vec3 viewPos;
uniform vec3 colorChange;
uniform float specularStrength;
uniform float InnerCone;
uniform	float OuterCone;
uniform bool spaceship;
uniform vec3 lightcycleColor;
uniform int size;

uniform sampler2D previousMask;

float hash(float n) { 
	return fract(sin(n) * 1e4);
}

float hash(vec2 p) {
	return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x))));
}

float noise(vec3 x) {
    const vec3 step = vec3(110, 241, 171);

    vec3 i = floor(x);
    vec3 f = fract(x);
 
    // For performance, compute the base input to a 1D hash from the integer part of the argument and the 
    // incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

    vec3 u = f * f * (3.0 - 2.0 * f);
    return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define NUM_OCTAVES 6

float fbm(vec3 x) {
	float v = 0.0;
	float a = 0.5;
	vec3 shift = vec3(0.0);
	for (int i = 0; i < NUM_OCTAVES; ++i) {
		v += a * noise(x);
		x = x * 2.0 + shift;
		a *= 0.5;
	}
	return v;
}

void main()
{    

	vec3 rgb = vec3(41.0 / 256, 49.0 / 256, 51.0 / 256);

	vec3 base = v_texCoord4D.xyz;
	base.x *= 3;

	vec3 scruffs = v_texCoord4D.xyz;
	//scruffs.x *= 0.3;
	scruffs.z *= 3;
	scruffs *= 0.5;

    float f = fbm(base);
	float b = fbm(scruffs);
	float black = b*b*b*b*b*b*b*b*b*b*b*b*b;
	
	float alphaOffset = f*f*f*f*f;
	float clearness = 0.975;

	color = vec4(rgb, clearness + (1.0 - clearness) * alphaOffset);
	color = vec4(color.xyz * (1-black), color.a + black * 0.7);
	if (color.a > 1) {
		color.a = 1;
	}
	//color = vec4(black, 0, 0, 1);
	
	vec3 normal = normalize(fs_in.Normal);

    // Ambient
    vec3 ambient = color.xyz;

    // Lighting
    vec3 diffLight = vec3(0.0f);
	vec3 specLight = vec3(0.0f);
    vec3 viewDir = normalize(viewPos - fs_in.FragPos);
    
	for(int i = 0; i < size; i++){
		vec3 lightDir = normalize((light[i].Position - fs_in.FragPos));
		vec3 reflectDir = reflect(-lightDir, normal);
		vec3 spotlightDir = normalize(light[i].Direction);

		float theta = dot(lightDir, normalize(-spotlightDir));
		float epsilon = (InnerCone - OuterCone);
		float intensity = clamp((theta - OuterCone) / epsilon, 0.0, 1.0);

		//calculate diffuse light
		float diff = max(dot(lightDir, normal), 0.0);
		vec3 result = light[i].Color * diff;

		// Attenuation (use quadratic as we have gamma correction)
		//float distance = length(fs_in.FragPos - light[i].Position);
		//result *= 1.0 / (distance * distance);
		diffLight += result * intensity;

		//calculate specular light
		float spec = pow(max(dot(viewDir, reflectDir), 0.0), 256);
		vec3 specular = specularStrength * spec * light[i].Color; 
		specLight += specular * intensity;
	}
	if (texture(previousMask, v_texCoord4D.xz).g < 0.9) {
		//Mask = vec4(0,0,0,1);
	} else {
		Mask = vec4(0,1,0,1);
	}
	Mask = v_texCoord4D;
	color = color + vec4(diffLight,0) + vec4(specLight,0);
}