#version 330 core
layout (location = 0) out vec4 FragColor;
layout (location = 3) out vec4 Bloom;

in vec2 TexCoords;

uniform sampler2D scene;
uniform sampler2D bloomBlur;
uniform bool bloom;
uniform float exposure;

void main()
{             
    const float gamma = 1.0;
    vec3 hdrColor = texture(scene, TexCoords).rgb;
	vec3 bloomColor = texture(bloomBlur, TexCoords).rgb * 0.5;
    if(bloom) {
        hdrColor += bloomColor; // additive blending
	} else {
		hdrColor += vec3(0.0);
	} 
    // tone mapping
    vec3 result = vec3(1.0) - exp(-hdrColor * exposure);
    // gamma correction      
    result = pow(result, vec3(1.0 / gamma));

	Bloom = vec4(result, 1.0f);
	FragColor = vec4(result, 1.0f);
}