#version 330 core
in vec3 position;
in vec3 normal;
in vec2 uv;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} vs_out;
flat out int lightNumber;
out float depthVS;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform int lightNr;

void main()
{
    gl_Position = projection * view * model * vec4(position, 1.0f);
    vs_out.FragPos = vec3(model * vec4(position, 1.0));   
    vs_out.TexCoords = uv;
	depthVS = gl_Position.z;
        
	lightNumber = lightNr;

    mat3 normalMatrix = transpose(inverse(mat3(model)));
    vs_out.Normal = normalize(normalMatrix * normal);
}