#version 330 core
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;
layout (location = 2) out vec4 Mask;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fs_in;

in float depthVS;

struct Light {
    vec3 Position;
    vec3 Color;
	vec3 Direction;
};

uniform Light light[4];
uniform sampler2D colorTexture;
uniform vec3 viewPos;
uniform vec3 colorChange;
uniform float specularStrength;
uniform float InnerCone;
uniform	float OuterCone;
uniform bool spaceship;
uniform bool mirror;
uniform vec3 lightcycleColor;
uniform int size;


void main()
{           
	if (fs_in.FragPos.y < 0) {
		discard;
	}
    vec3 color = texture(colorTexture, fs_in.TexCoords).rgb + colorChange;
    vec3 normal = normalize(fs_in.Normal);

    // Ambient
    vec3 ambient = color;

    // Lighting
    vec3 diffLight = vec3(0.0f);
	vec3 specLight = vec3(0.0f);
    vec3 viewDir = normalize(viewPos - fs_in.FragPos);	

	for(int i = 0; i < size; i++){
		vec3 lightDir = normalize(light[i].Position - fs_in.FragPos);
		vec3 reflectDir = reflect(-lightDir, normal); 
		vec3 spotlightDir = normalize(light[i].Direction);

		float theta = dot(lightDir, normalize(-spotlightDir));
		float epsilon = (InnerCone - OuterCone);
		float intensity = clamp((theta - OuterCone) / epsilon, 0.0, 1.0);

		//calculate diffuse light
		float diff = max(dot(lightDir, normal), 0.0);
		vec3 result = light[i].Color * diff * color;

		// Attenuation (use quadratic as we have gamma correction)
		//float distance = length(fs_in.FragPos - light[i].Position);
		//result *= 1.0 / (distance * distance);
		diffLight += result * intensity;

		//calculate specular light
		float spec = pow(max(dot(viewDir, reflectDir), 0.0), 256);
		vec3 specular = specularStrength * spec * light[i].Color*0.5; 
		specLight += specular * intensity;
	}

    vec3 result = ambient + diffLight + specLight;

    // Check whether result is higher than some threshold, if so, output as bloom threshold color
    float brightness = dot(result, vec3(0.2126, 0.7152, 0.0722));

    if(brightness > 1.0){
        BrightColor = vec4(result, 1.0);
	} else {
		BrightColor = vec4(0,0,0,1);
	}
    
    FragColor = vec4(result, 1.0f);
	Mask = vec4(0,0,0,1);
	if(spaceship) {
		/*
		if(mirror){
			Mask = vec4((1-depthVS*0.01),0.0,0.0,1.0);
		} else {
			Mask = vec4((1-depthVS*0.01),1.0,0.0,1.0);
		}
		*/
		Mask.g = 1;
		if(result.x > 0.3) {
			FragColor = vec4(lightcycleColor ,1.0);
			BrightColor = vec4(lightcycleColor, 1.0);
		}
	} else {
		Mask = vec4(0,0,0,1);
	}
}