#version 440 core

in vec3 texCoords;
in vec3 fWorldPos;
out vec4 outColor;
layout (location = 10) uniform float camHeight;

uniform sampler2D skycolor;
uniform samplerCube skybox;
uniform mat4 view;

void main()
{
    outColor = texture(skybox, texCoords);

    if(camHeight < 0) {
      float normalizedDist = -fWorldPos.y * 0.5f + 1f;
  		float waterDist = clamp(normalizedDist , 0.0, 1.0);
		outColor = vec4(mix(texture(skybox, texCoords).rgb, vec3(0.1f,0.3f,0.33f)*0.3, waterDist* 1.0f), 1.0f);
    }
		//float waterDist = normalized == 0 ? 0 : 0.3;

		//outColor = vec4(0.3 * waterDist * waterDist, 0.5 * waterDist, 0.55 * waterDist, 1.0);
    //outColor = vec4(texture(skycolor, vec2(0.9f, 0.1f)).rgb, 1.0f);

}
