#version 330 core

layout(location=0) in vec3 position;
layout(location=1) in vec2 vTexcoord;
layout(location=2) in vec3 normals;

out	vec2 fTexcoord;
out vec3 fNormals;
out vec3 fPosition;
out vec4 shadowCoord1;
out vec4 shadowCoord2;
out float visibility;
out vec4 worldPosition;

uniform mat4 model;
uniform mat4 view;
uniform mat4 proj;
uniform mat4 depthBias;
uniform mat4 depthVP1;
uniform mat4 depthVP2; //spotlight

const float density = 0.009;
const float gradient = 2.5;

void main(void) {
	worldPosition = model * vec4(position, 1.0f);
	vec4 relativeToCamPosition = view * worldPosition;

	gl_Position = proj * relativeToCamPosition;

	shadowCoord1 =  depthBias * depthVP1 * worldPosition;
	shadowCoord1.z = clamp(shadowCoord1.z, 0.0, 1.0);

	shadowCoord2 = depthBias * depthVP2 * worldPosition;

	float toCamDist = length(relativeToCamPosition);
	visibility = exp(-pow((toCamDist * density), gradient));
	visibility = clamp(visibility, 0.0, 1.0);

	fNormals = mat3(transpose(inverse(model))) * normals;
	fTexcoord = vTexcoord;
	fPosition = worldPosition.xyz;

}
