#version 410 core

layout(location=0) in vec3 position;
layout(location=1) in vec2 vTexcoord;
layout(location=2) in vec3 normals;

out vec2 fTexcoord;

uniform mat4 model;
uniform mat4 view;
uniform mat4 proj;

void main(void) {

	vec4 worldPosition = model * vec4(position, 1.0);
	gl_Position = proj * view * worldPosition;
	fTexcoord = vTexcoord;
}
