#version 430 core

in vec2 fTexcoord;

out vec4 outColor;

uniform sampler2D tex;
layout (location = 0) uniform int horizontal;

const float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main(void) { 

	vec2 texSizeInv = 1.0 / textureSize(tex, 0);
	vec3 total = texture(tex, fTexcoord).rgb * weight[0];

	if (horizontal == 1) {
		for (int i = 1; i < 5; i++) {
			total += texture(tex, fTexcoord + vec2(i, 0.0) * texSizeInv).rgb * weight[i];
			total += texture(tex, fTexcoord - vec2(i, 0.0) * texSizeInv).rgb * weight[i];
		}
	} else {
		for (int i = 1; i < 5; i++) {
			total += texture(tex, fTexcoord + vec2(0.0, i) * texSizeInv).rgb * weight[i];
			total += texture(tex, fTexcoord - vec2(0.0, i) * texSizeInv).rgb * weight[i];
		}
	}

	outColor = vec4(total, 1.0);
}