#version 330 core

in vec4 fPosition;
out vec4 outColor;

float linearizeDepth(float depth) {
	float near = 1.0f;
	float far = 70.0f;
    return (2.0 * near ) / (far + near - depth * (far - near));
}

void main(void) {
	//float depth = gl_FragCoord.z;
	float depth = (fPosition.z / fPosition.w) * 0.5 + 0.5;
	depth = linearizeDepth(depth);
	float moment1 = depth ;
	float moment2 = depth * depth;
	
	float dx = dFdx(depth);
	float dy = dFdy(depth);
	moment2 += 0.25 * (dx*dx + dy*dy) ;

	outColor = vec4(moment1, moment2, 0, 0);

	float distributeValue = 256;
	float distInv = 1.0 / distributeValue;
	vec2 moments = vec2(moment1, moment2);	
	vec2 highParts;
	vec2 lowParts = modf(moments * distributeValue, highParts);
	outColor = vec4(highParts * distInv , lowParts);
	
}

