#version 330 core

in vec2 fTexcoord;

out vec4 outColor;

uniform sampler2D tex;
uniform float nPassNumber;

void main (void) {
	int base = 16;
	ivec2 texCoord = ivec2(gl_FragCoord.xy - 0.5);
	vec4 total = texture(tex, fTexcoord); 

	for (float i = 1; i < base; i++) {
		ivec2 coord = ivec2(texCoord.x - int(i * nPassNumber), texCoord.y);
		vec4 texel = texelFetch(tex, coord, 0);
		total += texel;
	}

	outColor = total;
}