#version 420

#define M_PI 3.1415926535897932384626433832795
//#define M_E  2.7182818284590452353602874713526

uniform sampler2D tex;
uniform ivec2 size;

in vec4 gl_FragCoord;

const float s = 0.8;
const float m = 0;
const float vScale = 7;
uniform float hScale;
const float vOffset = -0.5;

out vec4 fragColor;

float gaussian(float mu, float sigmaSq, vec2 p){

	return exp( (-(p.x * p.x + p.y * p.y)/(2*sigmaSq)))/(2*M_PI*sigmaSq);

}


void main(void)
{
	
	vec2 pos = gl_FragCoord.xy/size;
	vec2 gaussParam = (2*pos -1) * hScale;
	
	float gaussResp = gaussian(m, s, gaussParam * gaussParam);
	
	float vignette = clamp(vScale * gaussResp + vOffset, 0, 1);
	
	vec4 c = texture(tex, pos, 0);
	
	// fragColor = vec4(vignette, vignette, vignette, 1.0);
	
    fragColor = vignette * c;
	
}


