#version 420

uniform sampler2D maxMipMap;
uniform ivec2 size; //1 (level 0) or 2 (level >0)
uniform int level;

layout(pixel_center_integer) in vec4 gl_FragCoord;

out vec4 fragColor;

void main(void)
{
    ivec2 maxSize = textureSize(maxMipMap, level) - 1;
 
    ivec2 pos1 = min(ivec2((gl_FragCoord.xy) * size), maxSize);
    ivec2 pos2 = min(pos1 + 1, maxSize);
    float c0 = texelFetch(maxMipMap, ivec2(pos1.x, pos1.y), level);
    float c1 = texelFetch(maxMipMap, ivec2(pos1.x, pos2.y), level);
    float c2 = texelFetch(maxMipMap, ivec2(pos2.x, pos1.y), level);
    float c3 = texelFetch(maxMipMap, ivec2(pos2.x, pos2.y), level);
    float c  = max( max(c0, c1), max(c2, c3) );
    fragColor = vec4(c, c, c, 1);
}
