#version 420

uniform ivec2 size; //the size of the textureInput
uniform sampler2D textureInput; //the input to be filtered
uniform float[41] taps; //the filter coefficients of the 1D fileter kernel
uniform int tapCount; //use this many taps
uniform vec2 dir; //blur in this direction
uniform int normalizeResult;

layout(pixel_center_integer) in vec4 gl_FragCoord;

out vec4 fragColor;

void main(void)
{
    vec2 pos0 = gl_FragCoord.xy / size;
    
    vec4 n = taps[0] * texture(textureInput, pos0);
    for (int i = 1; i < tapCount; ++i)
        n += taps[i] * ( texture(textureInput, pos0 + dir * i) + texture(textureInput, pos0 - dir * i) );

    if (normalizeResult == 0)
        fragColor = n;
    else
        fragColor = vec4(normalize(n.xyz), max(0, log2((size.x + size.y) * n.w)));
}
