#version 420

uniform sampler2D tex;
uniform sampler2D grainTex;
uniform int time;
uniform ivec2 size;
uniform float grainScale;
uniform float saturation;
uniform float brightness;

in vec4 gl_FragCoord;

out vec4 fragColor;

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(void)
{
	
	vec2 pos = gl_FragCoord.xy/size;
	
	
	vec4 c = texture(tex, pos, 0);
	
	float tstep = mod(time/100, 1000);
	
    vec4 grain = texture(grainTex, vec2(rand(gl_FragCoord.xy + rand(vec2(tstep, tstep))), rand(gl_FragCoord.xy + rand(vec2(tstep, tstep)))), 0);
//    vec4 grain = texture(grainTex, vec2(rand(gl_FragCoord.xy+ tstep), rand(gl_FragCoord.xy - tstep)), 0);

    //color saturation for intro-BW-effect
    float bw = 0.3 * c.x + 0.59 * c.y + 0.11 * c.z;
    c = (1 - saturation) * bw + saturation * c;

    fragColor = brightness * (c + grainScale * (grain - 0.5));
	// fragColor = c;
	// fragColor = grain;
	
}


