#version 420

uniform sampler2D heightfield;
uniform ivec2 size;

layout(pixel_center_integer) in vec4 gl_FragCoord;

out vec4 fragColor;

void main(void)
{
    ivec2 pos0 = min(ivec2(gl_FragCoord.xy), size);
    ivec2 posP = min(pos0 + 1, size);
    ivec2 posN = max(pos0 - 1, ivec2(0, 0));
    float c  =      texelFetch(heightfield, ivec2(pos0.x, pos0.y), 0);
    float px = (c - texelFetch(heightfield, ivec2(posP.x, pos0.y), 0)) * size.x;
    float nx = (c - texelFetch(heightfield, ivec2(posN.x, pos0.y), 0)) * size.x;
    float py = (c - texelFetch(heightfield, ivec2(pos0.x, posP.y), 0)) * size.y;
    float ny = (c - texelFetch(heightfield, ivec2(pos0.x, posN.y), 0)) * size.y;
    vec3 n0 = normalize(vec3( px,  py, 1));
    vec3 n1 = normalize(vec3(-nx,  py, 1));
    vec3 n2 = normalize(vec3(-nx, -ny, 1));
    vec3 n3 = normalize(vec3( px, -ny, 1));
    vec3 n = n0 + n1 + n2 + n3;
    float blur = max( max( max(dot(n0,n1), dot(n0,n2)), max(dot(n0,n3), dot(n1,n2)) ), max(dot(n1,n3), dot(n2,n3)) );
    blur = abs(tan(acos(clamp(blur, -1, 1)) / 2));
    fragColor = vec4(n, blur);
}
