#version 430

layout(points) in;
layout(triangle_strip, max_vertices = 48) out;

uniform mat4 viewProjectionMatrix;

out vec3 texcoord;

/*
void m_emitTriangle(vec4 first, vec4 second, vec4 third)
{
	vec4 cPos = viewProjectionMatrix * first;
	gl_Position = cPos.xyww;						//set the z coordinate such that it becomes 1 after perspective (farthest z-value)
	texcoord = (first.xyz + vec3(1.0,1.0,1.0)) / 2;		//the texcoord is just its model space position (normalized to texture space)
	EmitVertex();

	cPos = viewProjectionMatrix * second;
	gl_Position = cPos.xyww;						
	texcoord = (second.xyz + vec3(1.0,1.0,1.0)) / 2;
	EmitVertex();

	cPos = viewProjectionMatrix * third;
	gl_Position = cPos.xyww;						
	texcoord = (third.xyz + vec3(1.0,1.0,1.0)) / 2;
	EmitVertex();

	EndPrimitive(); 
}
*/


void m_emitTriangle(vec4 first, vec4 second, vec4 third)
{
	vec4 cPos = viewProjectionMatrix *first;
	gl_Position = vec4(cPos.x, cPos.y, 0, cPos.w) ;						//set the z coordinate such that it becomes 1 after perspective (farthest z-value)
	//texcoord = ( (first.xyz + vec3(1.0,1.0,1.0))/ 2); 		//the texcoord is just its model space position (normalized to texture space)
	texcoord = first.xyz*(-1.0f);
	EmitVertex();

	cPos = viewProjectionMatrix *second;
	gl_Position = vec4(cPos.x, cPos.y,0, cPos.w) ;						
	//texcoord = ( (second.xyz + vec3(1.0,1.0,1.0))/ 2); 
	texcoord = second.xyz*(-1.0f);
	EmitVertex();

	cPos = viewProjectionMatrix *third;
	gl_Position = vec4(cPos.x, cPos.y,0, cPos.w) ;						
	//texcoord = ( (third.xyz + vec3(1.0,1.0,1.0))/ 2); 
	texcoord = third.xyz*(-1.0f);
	EmitVertex();

	EndPrimitive(); 
}


void main() 
{

	
	vec4 A = vec4(-1.0,-1.0,1.0,1.0);
	vec4 B = vec4(1.0,-1.0,1.0,1.0);
	vec4 C = vec4(1.0,-1.0,-1.0,1.0);
	vec4 D = vec4(-1.0,-1.0,-1.0,1.0);
	vec4 E = vec4(-1.0,1.0,1.0,1.0);
	vec4 F = vec4(1.0,1.0,1.0,1.0);
	vec4 G = vec4(1.0,1.0,-1.0,1.0);
	vec4 H = vec4(-1.0,1.0,-1.0,1.0);
	
	/*
	vec4 A = vec4(-10.0,-10.0,10.0,1.0);
	vec4 B = vec4(10.0,-10.0,10.0,1.0);
	vec4 C = vec4(10.0,-10.0,-10.0,1.0);
	vec4 D = vec4(-10.0,-10.0,-10.0,1.0);
	vec4 E = vec4(-10.0,10.0,10.0,1.0);
	vec4 F = vec4(10.0,10.0,10.0,1.0);
	vec4 G = vec4(10.0,10.0,-10.0,1.0);
	vec4 H = vec4(-10.0,10.0,-10.0,1.0);
	*/

	//bottom face
	m_emitTriangle(A,B,D);
	m_emitTriangle(C,B,D);

	//top face
	m_emitTriangle(E,F,H);
	m_emitTriangle(G,F,H);

	//left face
	m_emitTriangle(A,D,E);
	m_emitTriangle(H,D,E);

	//right face
	m_emitTriangle(B,F,C);
	m_emitTriangle(G,F,C);

	//front face
	m_emitTriangle(A,B,E);
	m_emitTriangle(F,B,E);

	//back face
	m_emitTriangle(G,H,C);
	m_emitTriangle(D,H,C);
}