#version 430

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 vertexTC;

uniform mat4 modelViewProjectionMatrix;
uniform mat3 normalMatrix;
uniform mat4 modelMatrix;

out vec2 UV;
out vec3 worldSpacePosition;
out vec3 varNormal;

void main() {
	UV = vertexTC;
	varNormal = vec4(normalize( normalMatrix * vertexNormal), 1.0).xyz;
	vec4 worldPosition = modelMatrix * vec4(vertexPosition, 1.0);
	worldSpacePosition = worldPosition.xyz/worldPosition.w;
	vec4 finalposHom = modelViewProjectionMatrix * vec4(vertexPosition,1.0);
	gl_Position = modelViewProjectionMatrix * vec4(vertexPosition,1.0);
}