#version 430

//FIRSTPASS OF THE SHADOW VOLUMES DRAWING STAGE:
//simply draw the scene without/ambient light, with the depth buffer enabled

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 vertexTC;

uniform mat4 modelViewProjectionMatrix;

out vec2 UV;
out vec3 worldSpacePosition;
out vec3 varNormal;

void main() {
	UV = vertexTC;
	varNormal = vec4(normalize( vertexNormal), 1.0).xyz;
	vec4 worldPosition = vec4(vertexPosition, 1.0);
	worldSpacePosition = worldPosition.xyz/worldPosition.w;
	gl_Position = modelViewProjectionMatrix * vec4(vertexPosition,1.0);
}