#version 430 core

in vec2 UV;
in vec3 worldSpacePosition;
in vec3 varNormal;

uniform sampler2D tex1;

uniform vec3 lightIntensity; // Amb., Diff., and Specular intensity
uniform vec3 ambientColor;
uniform vec3 ambientReflectivity; // Ambient reflectivity

out vec4 FragColor;


vec3 phong() {

	vec3 ambientLight = ambientColor * ambientReflectivity * lightIntensity.r;

	vec3 textureColor = texture( tex1, UV ).rgb;

	return (ambientLight) * textureColor;
}

void main() {
	FragColor = vec4( phong() , 0);
}