#version 430 core

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 vertexTC;

uniform mat4 modelMatrix;

out vec3 WorldPos_TESSCTRL_in;
out vec2 TexCoord_TESSCTRL_in;
out vec3 Normal_TESSCTRL_in;

void main()
{ 
    WorldPos_TESSCTRL_in = (modelMatrix * vec4(vertexPosition, 1.0)).xyz; 
    TexCoord_TESSCTRL_in = vertexTC; 
    Normal_TESSCTRL_in = normalize((modelMatrix * vec4(vertexNormal, 0.0)).xyz); 
}