 #version 400 core

 in vec2 UV;

 uniform float exposure;
 uniform float decay;
 uniform float density;
 uniform float weight;
 uniform vec2 lightPositionOnScreen;
 uniform sampler2D firstPass;

 uniform int numSamples;

 out vec4 FragColor;

 void main()

 {	
 	vec2 deltaTextCoord = vec2( UV - lightPositionOnScreen.xy );
 	vec2 texCoord = UV;

 	deltaTextCoord *= 1.0 /  float(numSamples) * density;
	FragColor = texture2D(firstPass, texCoord );
 	float illuminationDecay = 1.0;

 	for(int i=0; i < numSamples ; i++)
  	{

    			texCoord -= deltaTextCoord;

    			vec4 sampl = texture2D(firstPass, texCoord );

    			sampl *= illuminationDecay * weight;

    			FragColor += sampl;

    			illuminationDecay *= decay;
 	}

 	FragColor *= exposure;
	FragColor = vec4(FragColor.rgb,1);
}