#version 430

layout (location = 0) in vec3 flarePosition;
layout (location = 1) in float flareSize;
layout (location = 2) in uint flareType;
layout (location = 3) in vec4 flareColor;

uniform mat4 modelViewProjectionMatrix;

flat out uint varaArrayIndex; // do not interpolate
flat out vec4 varaColor;

void main(void) {
	varaArrayIndex = flareType;
    varaColor = flareColor;
	gl_PointSize = flareSize*150;
	gl_Position = modelViewProjectionMatrix * vec4(flarePosition, 1.0);
}