#version 430 core

in vec2 UV;
in vec3 worldSpacePosition;
in vec3 varNormal;

uniform samplerCube cube_texture;

uniform vec3 cameraPositionWS;

out vec4 FragColor;

void main() {
	vec3 view = normalize(worldSpacePosition - cameraPositionWS);
	vec3 texcoord = reflect(view, varNormal);
	vec4 texcolor = texture(cube_texture,texcoord);
	FragColor = texcolor;
}