#version 430 core

in vec2 TexCoord_FS_in;
in vec3 WorldPos_FS_in;
in vec3 Normal_FS_in;

uniform sampler2D tex1;

uniform vec3 cameraPositionWS;
uniform vec3 lightPositionWS;
uniform vec3 lightIntensity; // Amb., Diff., and Specular intensity
uniform vec3 ambientColor;
uniform vec3 diffuseColor;
uniform vec3 specularColor;
uniform vec3 diffuseReflectivity; // Diffuse reflectivity
uniform vec3 ambientReflectivity; // Ambient reflectivity
uniform vec3 specularReflectivity; // Specular reflectivity
uniform float shininess; // Specular shininess factor

out vec4 FragColor;

vec3 phong() {
	vec3 N = normalize( Normal_FS_in );
	vec3 L = normalize( lightPositionWS - WorldPos_FS_in );
	vec3 V = normalize( cameraPositionWS - WorldPos_FS_in);
	vec3 H = normalize( V + L );
	float diffuseReflection = max( dot(N, L), 0.0 );
	float spec = max(dot(N, H), 0.0 );
	float specularReflection = pow(spec, shininess );

	vec3 ambientLight = ambientColor * ambientReflectivity * lightIntensity.r;
	vec3 diffuseLight = diffuseColor * diffuseReflectivity * lightIntensity.g * diffuseReflection;

	vec3 textureColor = texture( tex1, TexCoord_FS_in ).rgb;
	vec3 specularLight = specularColor * specularReflectivity * lightIntensity.b * specularReflection;

	return (ambientLight + diffuseLight) * textureColor + specularLight;
}

void main() {
	FragColor = vec4( phong() , 0);
}