#version 130

// 'fixed function' http://www.cs.cmu.edu/~djames/15-462/Fall03/notes/11-splines.pdf
// seems like a good source http://soliton.ae.gatech.edu/people/jcraig/classes/ae4375/notes/b-splines-04.pdf

uniform sampler2D controlPoints;
uniform mat4 modelMatrix;

uniform float colorOffset;
uniform float colorScale;
uniform float colorOverride;

in vec3 in_Position;
in vec3 in_Color;

out vec3 position;
out vec3 color;

void main()
{
    
    ivec2 numControlPoints = textureSize(controlPoints, 0);
	float size = numControlPoints.x;
    
    vec4 pos = vec4(in_Position, 1.0);
    
    vec3[4] controlPointArr;
    
    //controlPointArr[0] = vec3(texture2D(controlPoints, vec2(pos.x - 1.0f/size, 0.5)).xyz);
    //controlPointArr[1] = vec3(texture2D(controlPoints, vec2(pos.x, 0.5)).xyz);
    //controlPointArr[2] = vec3(texture2D(controlPoints, vec2(pos.x + 1.0f/size, 0.5)).xyz);
    //controlPointArr[3] = vec3(texture2D(controlPoints, vec2(pos.x + 2.0f/size, 0.5)).xyz);
    
    controlPointArr[0] = (modelMatrix * vec4(vec3(texture2D(controlPoints, vec2(0.0f/size, 0.5)).xyz), 1.0)).xyz;
    controlPointArr[1] = (modelMatrix * vec4(vec3(texture2D(controlPoints, vec2(1.0f/size, 0.5)).xyz), 1.0)).xyz;
    controlPointArr[2] = (modelMatrix * vec4(vec3(texture2D(controlPoints, vec2(2.0f/size, 0.5)).xyz), 1.0)).xyz;
    controlPointArr[3] = (modelMatrix * vec4(vec3(texture2D(controlPoints, vec2(3.0f/size, 0.5)).xyz), 1.0)).xyz;
    
    mat4 bMat = mat4(
    	-1.0,  3.0, -3.0,  1.0,	// first column
    	 3.0, -6.0,  0.0,  4.0,
    	-3.0,  3.0,  3.0,  1.0,
    	 1.0,  0.0,  0.0,  0.0
    );
    bMat = 1.0/6.0 * bMat;
    
    //float left = controlPointArr[0].x;	//pos.x - 1.0f/size;		// needs to be cast to texture sampling size
    //float right = controlPointArr[3].x;	//pos.x + 2.0f/size;		// needs to be cast to texture sampling size
    float t = pos.x;					//(pos.x - left)/(right - left);
    
    vec4 tVec = vec4(t*t*t, t*t, t, 1);
    
    mat4x3 cpVec = mat4x3(
    	controlPointArr[0],
    	controlPointArr[1],
    	controlPointArr[2],
    	controlPointArr[3]
    );
    mat3x4 tmp = (bMat) * transpose(cpVec);
    // transpose tVec
    //vec3 point = tVec * 1.0/6.0 * bMat * controlPointArr;
    vec3 point = transpose(tmp) * tVec;
    
    // output
    gl_Position = vec4(point.xyz, 1.0);
    //gl_Position = vec4(controlPointArr[3].xyz, 1.0);
    position = pos.xyz;
    //position.x = t;
	
	float c = position.x*colorScale + colorOffset;
	color = vec3(1.0-c, c, 0.0);
	
	color *= colorOverride;
}