/*
 * Decompiled with CFR 0.152.
 */
package tools;

import org.lwjgl.util.vector.Matrix4f;

public class Matrix
extends Matrix4f {
    private static final long serialVersionUID = 1L;

    public static float[] identity() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] orthogonal(float sizeX, float sizeY, float zNear, float zFar) {
        float[] out = Matrix.identity();
        out[0] = 1.0f / sizeX;
        out[5] = 1.0f / sizeY;
        out[10] = 2.0f / (zNear - zFar);
        out[11] = (zFar + zNear) / (zNear - zFar);
        return out;
    }

    public static float[] perspective(float fovy, float aspect, float zNear, float zFar) {
        float[] out = Matrix.identity();
        float f = 1.0f / (float)Math.tan(Math.toRadians(fovy) / 2.0);
        out[0] = f / aspect;
        out[5] = f;
        out[10] = (zFar + zNear) / (zNear - zFar);
        out[11] = 2.0f * zFar * zNear / (zNear - zFar);
        out[14] = -1.0f;
        out[15] = 0.0f;
        return out;
    }

    public static float[] matrixToArray(Matrix4f m) {
        return new float[]{m.m00, m.m10, m.m20, m.m30, m.m01, m.m11, m.m21, m.m31, m.m02, m.m12, m.m22, m.m32, m.m03, m.m13, m.m23, m.m33};
    }

    public float[] getMatrix() {
        return new float[]{this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33};
    }

    public float[] getTransposeMatrix() {
        return new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }
}

