/*
 * Decompiled with CFR 0.152.
 */
package renderer.shader;

import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import renderer.shader.Shader;

public class ShaderCollection {
    public static final int BSPLINE = 0;
    private ShaderWrapper activeShader = null;
    private ArrayList<ShaderWrapper> shader = new ArrayList();
    private int basic_in_Position;
    private int basic_in_Color;

    public ShaderCollection() {
        this.shader.add(new ShaderWrapper("icons/shader/bspline"));
        this.basic_in_Position = this.shader.get(0).initInOut("in_Position");
        this.basic_in_Color = this.shader.get(0).initInOut("in_Color");
    }

    public void setShaderParameters(Object ... params) {
        this.activeShader.setShaderParameters(params);
    }

    public int getVertexLocation(int type) {
        switch (type) {
            case 0: {
                return this.shader.get(type).getInOut(this.basic_in_Position);
            }
        }
        return -1;
    }

    public int getNormalLocation(int type) {
        return -1;
    }

    public int getTextCoordLocation(int type) {
        return -1;
    }

    public int getColorLocation(int type) {
        switch (type) {
            case 0: {
                return this.shader.get(type).getInOut(this.basic_in_Color);
            }
        }
        return -1;
    }

    public int getmodelMatrixLocation(int type) {
        return -1;
    }

    public void bind(int name) {
        GL11.glPolygonMode((int)1032, (int)6914);
        this.shader.get(name).bind();
        this.activeShader = this.shader.get(name);
    }

    public void unbind(int name) {
        this.shader.get(name).unbind();
    }

    public void unbindAll() {
        int i = 0;
        while (i < this.shader.size()) {
            this.shader.get(i).unbind();
            ++i;
        }
    }

    private class ShaderWrapper
    extends Shader {
        private HashMap<String, Integer> shaderUniforms;

        public ShaderWrapper(String path) {
            super(path);
        }

        public void setShaderParameters(Object ... params) {
            int i;
            if (params.length % 2 != 0) {
                throw new RuntimeException("ShaderCollection: Invalid number of Shader parameters.");
            }
            if (this.shaderUniforms == null) {
                this.shaderUniforms = new HashMap();
                i = 0;
                while (i < params.length) {
                    String uniformName = String.valueOf(params[i]);
                    Integer location = this.initUniform(uniformName);
                    if (location == -1) {
                        System.out.println("ShaderCollection: Uniform " + uniformName + " not found in Shader file.");
                    }
                    this.shaderUniforms.put(uniformName, location);
                    i += 2;
                }
            }
            i = 0;
            while (i < params.length) {
                Integer location = this.shaderUniforms.get(params[i]);
                if (location != null) {
                    Object[] arr;
                    if (params[i + 1] instanceof Integer) {
                        this.setValue1i(location, (Integer)params[i + 1]);
                    } else if (params[i + 1] instanceof Float) {
                        this.setValue1f(location, ((Float)params[i + 1]).floatValue());
                    } else if (params[i + 1] instanceof int[]) {
                        arr = (int[])params[i + 1];
                        if (arr.length == 2) {
                            this.setValueVec2f(location, arr[0], arr[1]);
                        }
                    } else if (params[i + 1] instanceof float[]) {
                        arr = (float[])params[i + 1];
                        if (arr.length == 2) {
                            this.setValueVec2f(location, arr[0], arr[1]);
                        } else if (arr.length == 3) {
                            this.setValueVec3f(location, arr[0], arr[1], arr[2]);
                        } else if (arr.length == 16) {
                            this.setValueMat4f((int)location, (float[])arr);
                        } else {
                            this.setValueFloatArray(location, (float[])arr);
                        }
                    } else {
                        System.out.println("ShaderCollection: Type " + params[i + 1].getClass().getName() + " not recognized.");
                    }
                } else {
                    System.out.println("ShaderColelction: Variable " + params[i] + " does not exsist in shader " + this.getName());
                }
                i += 2;
            }
        }
    }
}

