/*
 * Decompiled with CFR 0.152.
 */
package renderer.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL21;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import tools.FileIO;

public class Shader {
    private String name;
    private int vertex_shader = 0;
    private int fragment_shader = 0;
    private int geometry_shader = 0;
    private int tess_control_shader = 0;
    private int tess_evaluation_shader = 0;
    private int program = 0;
    private FloatBuffer matrix = BufferUtils.createFloatBuffer((int)16);
    private boolean debug = false;
    private ArrayList<Integer> value_ids = new ArrayList();
    private boolean pre_opengl20 = false;
    private boolean geom_shader = true;
    private boolean tess_shader = true;

    public Shader(String path) {
        BufferedReader reader;
        this.name = path;
        String vert_path = String.valueOf(path) + ".vert";
        String geom_path = String.valueOf(path) + ".geom";
        String frag_path = String.valueOf(path) + ".frag";
        String tess_control_path = String.valueOf(path) + ".tc";
        String tess_evaluation_path = String.valueOf(path) + ".te";
        String version = GL11.glGetString((int)7938);
        if (Integer.valueOf(version.substring(0, 1)) < 2) {
            this.pre_opengl20 = true;
            if (!GLContext.getCapabilities().GL_ARB_shader_objects) {
                System.out.println("Pre OpenGL 2.0 without GL_ARB_shader_objects support.");
            }
            if (!GLContext.getCapabilities().GL_ARB_vertex_shader) {
                System.out.println("Pre OpenGL 2.0 without GL_ARB_vertex_shader support.");
            }
            if (!GLContext.getCapabilities().GL_ARB_fragment_shader) {
                System.out.println("Pre OpenGL 2.0 without GL_ARB_vertex_shader support.");
            }
        }
        String line = "";
        String vertex_shader_source = "";
        try {
            reader = new BufferedReader(FileIO.resolveAbsolutePathFR(vert_path));
            while ((line = reader.readLine()) != null) {
                vertex_shader_source = String.valueOf(vertex_shader_source) + line + "\n";
            }
            reader.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.vertex_shader = !this.pre_opengl20 ? this.compile(35633, vertex_shader_source) : this.compilePre20(35633, vertex_shader_source);
        if (this.vertex_shader == 0) {
            System.out.println("Error Vertex Shader!");
        }
        String geometry_shader_source = "";
        try {
            InputStreamReader fr = FileIO.resolveAbsolutePathFR(geom_path);
            if (fr != null) {
                reader = new BufferedReader(fr);
                while ((line = reader.readLine()) != null) {
                    geometry_shader_source = String.valueOf(geometry_shader_source) + line + "\n";
                }
                reader.close();
            } else {
                this.geom_shader = false;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.geom_shader) {
            this.geometry_shader = this.compile(36313, geometry_shader_source);
            if (this.geometry_shader == 0) {
                System.out.println("Error Geometry Shader!");
            }
        }
        String tess_control_shader_source = "";
        try {
            InputStreamReader fr = FileIO.resolveAbsolutePathFR(tess_control_path);
            if (fr != null) {
                reader = new BufferedReader(fr);
                while ((line = reader.readLine()) != null) {
                    tess_control_shader_source = String.valueOf(tess_control_shader_source) + line + "\n";
                }
                reader.close();
            } else {
                this.tess_shader = false;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.tess_shader) {
            this.tess_control_shader = this.compile(36488, tess_control_shader_source);
            if (this.tess_control_shader == 0) {
                System.out.println("Error Tessellation Control Shader!");
            }
        }
        String tess_evaluation_shader_source = "";
        try {
            InputStreamReader fr = FileIO.resolveAbsolutePathFR(tess_evaluation_path);
            if (fr != null) {
                reader = new BufferedReader(fr);
                while ((line = reader.readLine()) != null) {
                    tess_evaluation_shader_source = String.valueOf(tess_evaluation_shader_source) + line + "\n";
                }
                reader.close();
            } else {
                this.tess_shader = false;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.tess_shader) {
            this.tess_evaluation_shader = this.compile(36487, tess_evaluation_shader_source);
            if (this.tess_evaluation_shader == 0) {
                System.out.println("Error Tessellation Evaluation Shader!");
            }
        }
        if (this.debug) {
            System.out.println("tessellation: " + this.tess_shader);
        }
        String fragment_shader_source = "";
        try {
            reader = new BufferedReader(FileIO.resolveAbsolutePathFR(frag_path));
            while ((line = reader.readLine()) != null) {
                fragment_shader_source = String.valueOf(fragment_shader_source) + line + "\n";
            }
            reader.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.fragment_shader = !this.pre_opengl20 ? this.compile(35632, fragment_shader_source) : this.compilePre20(35632, fragment_shader_source);
        if (this.fragment_shader == 0) {
            System.out.println("Error Fragment Shader!");
        }
        if (!this.pre_opengl20) {
            this.link(path);
        } else {
            this.linkPre20(path);
        }
    }

    private int compilePre20(int type, String shader_source) {
        int shader = ARBShaderObjects.glCreateShaderObjectARB((int)type);
        if (shader == 0) {
            System.out.println("Impossible to create shader object!");
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)shader_source);
        ARBShaderObjects.glCompileShaderARB((int)shader);
        return shader;
    }

    private int compile(int type, String shader_source) {
        int shader = GL20.glCreateShader((int)type);
        if (shader == 0) {
            System.out.println("Impossible to create shader object!");
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)shader_source);
        GL20.glCompileShader((int)shader);
        return shader;
    }

    private void linkPre20(String source) {
        String debugOut;
        this.program = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)this.vertex_shader);
        ARBShaderObjects.glAttachObjectARB((int)this.program, (int)this.fragment_shader);
        ARBShaderObjects.glLinkProgramARB((int)this.program);
        IntBuffer result = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)this.program, (int)35714, (IntBuffer)result);
        if (result.get(0) != 1) {
            System.out.println("Shader compile error! \n\nin: " + source + "\n\n" + GL20.glGetProgramInfoLog((int)this.program, (int)5000));
        }
        if ((debugOut = GL20.glGetProgramInfoLog((int)this.program, (int)5000)).length() > 0) {
            System.out.println(debugOut);
        }
    }

    private void link(String source) {
        String debugOut;
        this.program = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.program, (int)this.vertex_shader);
        if (this.geom_shader) {
            GL20.glAttachShader((int)this.program, (int)this.geometry_shader);
        }
        if (this.tess_shader) {
            GL20.glAttachShader((int)this.program, (int)this.tess_control_shader);
            GL20.glAttachShader((int)this.program, (int)this.tess_evaluation_shader);
        }
        GL20.glAttachShader((int)this.program, (int)this.fragment_shader);
        GL30.glBindFragDataLocation((int)this.program, (int)0, (CharSequence)"out_Color");
        GL30.glBindFragDataLocation((int)this.program, (int)1, (CharSequence)"out_ColorTwo");
        GL20.glLinkProgram((int)this.program);
        IntBuffer result = BufferUtils.createIntBuffer((int)1);
        GL20.glGetProgram((int)this.program, (int)35714, (IntBuffer)result);
        if (result.get(0) != 1) {
            System.out.println("Shader compile error! \n\nin: " + source + "\n\n" + GL20.glGetProgramInfoLog((int)this.program, (int)5000));
        }
        if ((debugOut = GL20.glGetProgramInfoLog((int)this.program, (int)5000)).length() > 0) {
            System.out.println(debugOut);
        }
    }

    public void bind() {
        if (!this.pre_opengl20) {
            GL20.glUseProgram((int)this.program);
            try {
                Util.checkGLError();
            }
            catch (OpenGLException openGLException) {
                // empty catch block
            }
            Util.checkGLError();
        } else {
            ARBShaderObjects.glUseProgramObjectARB((int)this.program);
        }
    }

    public void unbind() {
        if (!this.pre_opengl20) {
            GL20.glUseProgram((int)0);
        } else {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    public int initUniform(String name) {
        int location = 0;
        location = !this.pre_opengl20 ? GL20.glGetUniformLocation((int)this.program, (CharSequence)name) : ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)name);
        this.value_ids.add(location);
        if (this.debug) {
            System.out.println("Added: " + name + " at " + (this.value_ids.size() - 1) + " location: " + location);
        }
        return this.value_ids.size() - 1;
    }

    public int initInOut(String name) {
        int location = 0;
        location = !this.pre_opengl20 ? GL20.glGetAttribLocation((int)this.program, (CharSequence)name) : ARBVertexShader.glGetAttribLocationARB((int)this.program, (CharSequence)name);
        this.value_ids.add(location);
        if (this.debug) {
            System.out.println("Added: " + name + " at " + (this.value_ids.size() - 1) + " location: " + location);
        }
        return this.value_ids.size() - 1;
    }

    public int getInOut(int position_in_location_array) {
        return this.value_ids.get(position_in_location_array);
    }

    public void setValue1i(int position_in_location_array, int value) {
        if (!this.pre_opengl20) {
            GL20.glUniform1i((int)this.value_ids.get(position_in_location_array), (int)value);
        } else {
            ARBShaderObjects.glUniform1iARB((int)this.value_ids.get(position_in_location_array), (int)value);
        }
    }

    public void setValue1f(int position_in_location_array, float value) {
        if (!this.pre_opengl20) {
            GL20.glUniform1f((int)this.value_ids.get(position_in_location_array), (float)value);
        } else {
            ARBShaderObjects.glUniform1fARB((int)this.value_ids.get(position_in_location_array), (float)value);
        }
    }

    public void setValueVec2f(int position_in_location_array, float x, float y) {
        if (!this.pre_opengl20) {
            GL20.glUniform2f((int)this.value_ids.get(position_in_location_array), (float)x, (float)y);
        } else {
            ARBShaderObjects.glUniform2fARB((int)this.value_ids.get(position_in_location_array), (float)x, (float)y);
        }
    }

    public void setValueVec3f(int position_in_location_array, float x, float y, float z) {
        if (!this.pre_opengl20) {
            GL20.glUniform3f((int)this.value_ids.get(position_in_location_array), (float)x, (float)y, (float)z);
        } else {
            ARBShaderObjects.glUniform3fARB((int)this.value_ids.get(position_in_location_array), (float)x, (float)y, (float)z);
        }
    }

    public void setValueVec4f(int position_in_location_array, float x, float y, float z, float w) {
        if (!this.pre_opengl20) {
            GL20.glUniform4f((int)this.value_ids.get(position_in_location_array), (float)x, (float)y, (float)z, (float)w);
        } else {
            ARBShaderObjects.glUniform4fARB((int)this.value_ids.get(position_in_location_array), (float)x, (float)y, (float)z, (float)w);
        }
    }

    public void setValueMat3f(int position_in_location_array, float[] value) {
        this.matrix.clear();
        int i = 0;
        while (i < 9) {
            this.matrix.put(value[i]);
            ++i;
        }
        this.matrix.flip();
        if (!this.pre_opengl20) {
            GL20.glUniformMatrix3((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)this.matrix);
        } else {
            ARBShaderObjects.glUniformMatrix3ARB((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)this.matrix);
        }
    }

    public void setValueMat4x3f(int position_in_location_array, FloatBuffer value) {
        if (!this.pre_opengl20) {
            GL21.glUniformMatrix4x3((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)value);
        } else {
            System.out.println("Shader: 4x4 Matrix not implemented!");
        }
    }

    public void setValueMat4f(int position_in_location_array, FloatBuffer value) {
        if (!this.pre_opengl20) {
            GL20.glUniformMatrix4((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)value);
        } else {
            ARBShaderObjects.glUniformMatrix4ARB((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)value);
        }
    }

    public void setValueMat4f(int position_in_location_array, float[] value) {
        this.matrix.clear();
        this.matrix.put(value);
        this.matrix.position(0);
        if (!this.pre_opengl20) {
            GL20.glUniformMatrix4((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)this.matrix);
        } else {
            ARBShaderObjects.glUniformMatrix4ARB((int)this.value_ids.get(position_in_location_array), (boolean)true, (FloatBuffer)this.matrix);
        }
    }

    public void setValueFloatArray(int position_in_location_array, float[] data) {
        FloatBuffer fData = BufferUtils.createFloatBuffer((int)data.length);
        fData.put(data);
        fData.flip();
        if (!this.pre_opengl20) {
            GL20.glUniform1((int)this.value_ids.get(position_in_location_array), (FloatBuffer)fData);
        } else {
            ARBShaderObjects.glUniform1ARB((int)this.value_ids.get(position_in_location_array), (FloatBuffer)fData);
        }
    }

    public String getName() {
        return this.name;
    }
}

