/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.Util;
import renderer.shader.ShaderCollection;

public class VBO {
    protected final int SIZE = 10;
    protected int actualSize;
    private IntBuffer vboIBO = BufferUtils.createIntBuffer((int)10);
    private IntBuffer vboId = BufferUtils.createIntBuffer((int)20);

    public VBO() {
        GL15.glGenBuffers((IntBuffer)this.vboIBO);
        GL15.glGenBuffers((IntBuffer)this.vboId);
        this.actualSize = 0;
    }

    public void update(int objectId, short[] indices, float[] vertices) {
        ShortBuffer ind = BufferUtils.createShortBuffer((int)indices.length);
        ind.put(indices);
        ind.position(0);
        GL15.glBindBuffer((int)34963, (int)this.vboIBO.get(objectId));
        GL15.glBufferData((int)34963, (ShortBuffer)ind, (int)35044);
        FloatBuffer in = BufferUtils.createFloatBuffer((int)vertices.length);
        in.put(vertices);
        in.position(0);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 0));
        GL15.glBufferData((int)34962, (FloatBuffer)in, (int)35040);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void updatePositions(int objectId, float[] vertices) {
        FloatBuffer in = BufferUtils.createFloatBuffer((int)vertices.length);
        in.put(vertices);
        in.position(0);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 0));
        GL15.glBufferData((int)34962, (FloatBuffer)in, (int)35040);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void updateColors(int objectId, float[] color) {
        FloatBuffer in = BufferUtils.createFloatBuffer((int)color.length);
        in.put(color);
        in.position(0);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 1));
        GL15.glBufferData((int)34962, (FloatBuffer)in, (int)35040);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void deleteAll() {
        GL15.glDeleteBuffers((IntBuffer)this.vboIBO);
        GL15.glDeleteBuffers((IntBuffer)this.vboId);
    }

    public void init(int objectId, FloatBuffer vertices, FloatBuffer colors, ShortBuffer indices) {
        GL15.glBindBuffer((int)34963, (int)this.vboIBO.get(objectId));
        GL15.glBufferData((int)34963, (ShortBuffer)indices, (int)35044);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 0));
        GL15.glBufferData((int)34962, (FloatBuffer)vertices, (int)35040);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 1));
        GL15.glBufferData((int)34962, (FloatBuffer)colors, (int)35040);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public void render(int objectId, int type, int indicesSize, int shaderType, ShaderCollection sc) {
        int vl = sc.getVertexLocation(shaderType);
        GL20.glEnableVertexAttribArray((int)vl);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 0));
        GL20.glVertexAttribPointer((int)vl, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        int cl = sc.getColorLocation(shaderType);
        GL20.glEnableVertexAttribArray((int)cl);
        GL15.glBindBuffer((int)34962, (int)this.vboId.get(2 * objectId + 1));
        GL20.glVertexAttribPointer((int)cl, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        if (indicesSize > 0) {
            GL15.glBindBuffer((int)34963, (int)this.vboIBO.get(objectId));
            try {
                Util.checkGLError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            GL11.glDrawElements((int)type, (int)indicesSize, (int)5123, (long)0L);
            try {
                Util.checkGLError();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GL20.glDisableVertexAttribArray((int)vl);
        GL20.glDisableVertexAttribArray((int)cl);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
    }
}

