/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.lwjgl.opengl.GL11;
import org.osgi.framework.Bundle;
import renderer.TextureCollection;

public class TextRenderer {
    private static final int MAX_HEIGHT = 128;
    private static final int MAX_LENGTH = 4096;
    private static final String CHAROFFSET = "  ";
    private TextureCollection textures;
    private String[] c = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "*", "+", "'", "#", ",", ";", ".", ":", "_", "-"};
    private int[] offsetInt;
    private float[] cx1;
    private float[] cy1;
    private float[] cx2;
    private float[] cy2;
    private float[] cxnext;
    private int textureIndex;

    public TextRenderer(String path, TextureCollection text, int textureIndex) {
        this.textures = text;
        this.textureIndex = textureIndex;
        this.offsetInt = new int[2 * this.c.length + 2];
        this.generateFont();
        text.addTextureQueue("customFont");
    }

    public StringInt loadFont(Graphics2D g) {
        URL url = this.resolveAbsolutePath("icons/Droid-Sans/DroidSans.ttf");
        Font font = null;
        if (url != null) {
            try {
                font = Font.createFont(0, url.openStream());
            }
            catch (FontFormatException | IOException e1) {
                throw new NullPointerException("No url " + url.getPath());
            }
        }
        font = font.deriveFont(0, 22.0f);
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(font);
        int currentLength = 0;
        this.offsetInt[0] = 0;
        String currentString = this.c[0];
        this.offsetInt[1] = metrics.stringWidth(this.c[0]);
        int i = 1;
        while (i < this.c.length) {
            currentString = String.valueOf(currentString) + CHAROFFSET;
            this.offsetInt[2 * i] = currentLength = metrics.stringWidth(currentString);
            currentString = String.valueOf(currentString) + this.c[i];
            this.offsetInt[2 * i + 1] = currentLength = metrics.stringWidth(currentString);
            ++i;
        }
        currentString = String.valueOf(currentString) + CHAROFFSET;
        this.offsetInt[this.offsetInt.length - 2] = currentLength = metrics.stringWidth(currentString);
        this.offsetInt[this.offsetInt.length - 1] = currentLength = metrics.stringWidth(currentString);
        this.cx1 = new float[this.c.length];
        this.cy1 = new float[this.c.length];
        this.cx2 = new float[this.c.length];
        this.cy2 = new float[this.c.length];
        this.cxnext = new float[this.c.length];
        float nextPowerTwo = (float)Math.pow(2.0, Math.ceil(Math.log(currentLength) / Math.log(2.0)));
        int i2 = 0;
        while (i2 < this.cx1.length) {
            this.cx1[i2] = (float)this.offsetInt[2 * i2] / nextPowerTwo;
            this.cx2[i2] = (float)this.offsetInt[2 * i2 + 2] / nextPowerTwo;
            this.cxnext[i2] = (float)this.offsetInt[2 * i2 + 1] / nextPowerTwo;
            this.cy1[i2] = 0.0f;
            this.cy2[i2] = 0.2f;
            ++i2;
        }
        StringInt out = new StringInt();
        out.string = currentString;
        out.measureSize = currentLength;
        return out;
    }

    public void generateFont() {
        BufferedImage image = new BufferedImage(4096, 128, 2);
        Graphics2D g = image.createGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g.setRenderingHints(rh);
        g.setColor(Color.white);
        StringInt str = this.loadFont(g);
        g.drawString(str.string, 0, 20);
        g.dispose();
    }

    private URL resolveAbsolutePath(String path) {
        Bundle bundle = Platform.getBundle((String)"callgraph");
        Path realPath = new Path(path);
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)realPath, null);
        URL resolved = null;
        try {
            resolved = FileLocator.resolve((URL)fileURL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resolved;
    }

    public void draw_string_centered(String text, float px, float py, float scale, float aspect) {
        float size = 0.0f;
        int i = 0;
        while (i < text.length()) {
            int j = 0;
            while (j < this.c.length) {
                if (this.c[j].equals(text.substring(i, i + 1))) {
                    size += (0.01f + this.cx2[j] - this.cx1[j]) * scale;
                } else if (text.substring(i, i + 1).equals(" ")) {
                    size += 3.0E-4f * scale;
                } else if (text.substring(i, i + 1).equals("/")) {
                    i += 2;
                }
                ++j;
            }
            ++i;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(size /= 2.0f)), (float)0.0f, (float)0.0f);
        this.draw_string(text, px, py, scale, aspect);
        GL11.glPopMatrix();
    }

    public void draw_string(String text, float px, float py, float scale, float aspect) {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.textures.bind_texture(this.textureIndex);
        GL11.glPushMatrix();
        float dx = 0.0f;
        int i = 0;
        while (i < text.length()) {
            int j = 0;
            while (j < this.c.length) {
                if (this.c[j].equals(text.substring(i, i + 1))) {
                    GL11.glTranslatef((float)(dx + 0.005f * scale), (float)0.0f, (float)0.0f);
                    dx = 8.0f * scale * (this.cxnext[j] - this.cx1[j]);
                    float dy = this.cy2[j] - this.cy1[j];
                    float dSize = 8.0f * scale * (this.cx2[j] - this.cx1[j]);
                    dy = (float)((double)dy * (0.8 * (double)scale * (double)(1.0f / aspect)));
                    GL11.glBegin((int)7);
                    GL11.glTexCoord2f((float)(this.cx1[j] + 5.0E-5f), (float)this.cy2[j]);
                    GL11.glVertex2f((float)px, (float)py);
                    GL11.glTexCoord2f((float)(this.cx2[j] - scale * 0.003f), (float)this.cy2[j]);
                    GL11.glVertex2f((float)(px + dSize), (float)py);
                    GL11.glTexCoord2f((float)(this.cx2[j] - scale * 0.003f), (float)this.cy1[j]);
                    GL11.glVertex2f((float)(px + dSize), (float)(py + dy));
                    GL11.glTexCoord2f((float)(this.cx1[j] + 5.0E-5f), (float)this.cy1[j]);
                    GL11.glVertex2f((float)px, (float)(py + dy));
                    GL11.glEnd();
                } else if (text.substring(i, i + 1).equals(" ")) {
                    GL11.glTranslatef((float)(3.0E-4f * scale), (float)0.0f, (float)0.0f);
                } else if (text.substring(i, i + 1).equals("/")) {
                    if (text.substring(++i, i + 1).equals("r")) {
                        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                    } else if (text.substring(i, i + 1).equals("w")) {
                        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    } else if (text.substring(i, i + 1).equals("g")) {
                        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                    ++i;
                }
                ++j;
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    private class StringInt {
        public String string;
        public int measureSize;

        private StringInt() {
        }
    }
}

