/*
 * Decompiled with CFR 0.152.
 */
package interaction;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class CollisionDetection {
    private ArrayList<BoundingInformation> boudingAreas;

    public CollisionDetection() {
        this.reset();
    }

    public void reset() {
        this.boudingAreas = new ArrayList();
    }

    public void addElement(float[] area) {
        this.boudingAreas.add(new BoundingInformation(new float[]{area[0], area[1], area[0] + area[2], area[1] + area[3]}));
    }

    public int getCollisionIndex(float[] pos, float[] scale) {
        int index = -1;
        int i = 0;
        while (i < this.boudingAreas.size()) {
            float[] b = this.boudingAreas.get((int)i).bb;
            if (b[0] < pos[0] && b[2] > pos[0] && b[1] < pos[1] && b[3] > pos[1]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void drawBB() {
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        int i = 0;
        while (i < this.boudingAreas.size()) {
            float[] p = this.boudingAreas.get((int)i).bb;
            GL11.glBegin((int)2);
            GL11.glVertex3f((float)p[0], (float)p[1], (float)0.0f);
            GL11.glVertex3f((float)p[2], (float)p[1], (float)0.0f);
            GL11.glVertex3f((float)p[2], (float)p[3], (float)0.0f);
            GL11.glVertex3f((float)p[0], (float)p[3], (float)0.0f);
            GL11.glEnd();
            ++i;
        }
    }

    private class BoundingInformation {
        public float[] bb;

        public BoundingInformation(float[] boundingArea) {
            this.bb = boundingArea;
        }
    }
}

