/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.ConnectionEdge;
import java.util.ArrayList;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;

public class HierarchyGraph {
    private static Integer edgeCount = 0;
    private HNode root;
    private DirectedGraph<HNode, Integer> g = new DefaultDirectedGraph(Integer.class);
    private ArrayList<ConnectionEdge> connections = new ArrayList();

    public HNode addRoot(String root) {
        this.root = new HNode(root);
        if (root.indexOf(".") > 0) {
            root = root.substring(0, root.lastIndexOf("."));
        }
        this.g.addVertex((Object)this.root);
        return this.root;
    }

    public HNode addNode(HNode parent, String node) {
        if (node.indexOf(".") > 0) {
            node = node.substring(0, node.lastIndexOf("."));
        }
        HNode out = new HNode(node);
        this.g.addVertex((Object)out);
        this.g.addEdge((Object)parent, (Object)out, (Object)edgeCount);
        edgeCount = edgeCount + 1;
        return out;
    }

    public void layoutGraph(float[] pos) {
        this.root.position = (float[])pos.clone();
        this.positionNodeReArrange(this.root, new float[]{0.0f, 1.0f});
    }

    private void positionNode(HNode parentNode, float[] verticalRange) {
        ArrayList outEdges = new ArrayList(this.g.outgoingEdgesOf((Object)parentNode));
        float rightOffset = 0.15f;
        int numChilds = outEdges.size();
        float range = verticalRange[1] - verticalRange[0];
        float offs = range / (float)numChilds;
        float horPosUpper = parentNode.position[1] - range / 2.0f;
        int i = 0;
        while (i < numChilds) {
            HNode child = (HNode)this.g.getEdgeTarget((Object)((Integer)outEdges.get(i)));
            float horPos = horPosUpper + offs / 2.0f + (float)i * offs;
            child.position = new float[]{parentNode.position[0] + rightOffset, horPos};
            ConnectionEdge c = new ConnectionEdge();
            c.path = new float[]{parentNode.position[0], parentNode.position[1], child.position[0], child.position[1]};
            this.connections.add(c);
            this.positionNode(child, new float[]{horPosUpper + (float)i * offs, horPosUpper + (float)(i + 1) * offs});
            ++i;
        }
    }

    private void positionNodeReArrange(HNode parentNode, float[] verticalRange) {
        ArrayList outEdges = new ArrayList(this.g.outgoingEdgesOf((Object)parentNode));
        float rightOffset = 0.15f;
        int numChilds = outEdges.size();
        float range = verticalRange[1] - verticalRange[0];
        float offs = range / (float)parentNode.numLeaves;
        float prevLeavesPos = 0.0f;
        float horPosUpper = parentNode.position[1] - range / 2.0f;
        int i = 0;
        while (i < numChilds) {
            HNode child = (HNode)this.g.getEdgeTarget((Object)((Integer)outEdges.get(i)));
            float horPos = horPosUpper + prevLeavesPos + offs * (float)child.numLeaves / 2.0f;
            child.position = new float[]{parentNode.position[0] + rightOffset, horPos};
            ConnectionEdge c = new ConnectionEdge();
            c.path = new float[]{parentNode.position[0], parentNode.position[1], child.position[0], child.position[1]};
            this.connections.add(c);
            this.positionNodeReArrange(child, new float[]{horPosUpper + prevLeavesPos, horPosUpper + prevLeavesPos + offs * (float)child.numLeaves});
            prevLeavesPos += offs * (float)child.numLeaves;
            ++i;
        }
    }

    public void reArrangeGraph() {
        this.getNumLeaves(this.root);
    }

    private int getNumLeaves(HNode parentNode) {
        int numLeaves = 0;
        ArrayList outEdges = new ArrayList(this.g.outgoingEdgesOf((Object)parentNode));
        int i = 0;
        while (i < outEdges.size()) {
            HNode child = (HNode)this.g.getEdgeTarget((Object)((Integer)outEdges.get(i)));
            numLeaves += this.getNumLeaves(child);
            ++i;
        }
        if (outEdges.size() == 0) {
            parentNode.numLeaves = 1;
            return 1;
        }
        parentNode.numLeaves = numLeaves;
        return numLeaves;
    }

    public float[] getPoints() {
        ArrayList nodes = new ArrayList(this.g.vertexSet());
        float[] out = new float[2 * nodes.size()];
        int i = 0;
        while (i < nodes.size()) {
            out[2 * i] = ((HNode)nodes.get((int)i)).position[0];
            out[2 * i + 1] = ((HNode)nodes.get((int)i)).position[1];
            ++i;
        }
        return out;
    }

    public String[] getPointLabels() {
        ArrayList nodes = new ArrayList(this.g.vertexSet());
        String[] out = new String[nodes.size()];
        int i = 0;
        while (i < out.length) {
            out[i] = ((HNode)nodes.get((int)i)).name;
            ++i;
        }
        return out;
    }

    public boolean[] getIsLeaf() {
        ArrayList nodes = new ArrayList(this.g.vertexSet());
        boolean[] out = new boolean[nodes.size()];
        int i = 0;
        while (i < out.length) {
            out[i] = ((HNode)nodes.get((int)i)).numLeaves == 1;
            ++i;
        }
        return out;
    }

    public HNode findNode(String name) {
        ArrayList nodes = new ArrayList(this.g.vertexSet());
        int i = 0;
        while (i < nodes.size()) {
            if (((HNode)nodes.get((int)i)).name.equals(name)) {
                return (HNode)nodes.get(i);
            }
            ++i;
        }
        return null;
    }

    public ArrayList<ConnectionEdge> getEdges() {
        return this.connections;
    }

    public class HNode {
        public String name = "";
        public float[] position = new float[]{0.0f, 0.0f};
        public int numLeaves;

        public HNode(String name) {
            this.name = name;
        }
    }
}

