/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class TextureCollection {
    private ArrayList<TextureLoadObject> textLoadData;
    private ArrayList<Texture> textures;
    private HashMap<String, Integer> fileNames;
    private ArrayList<ArrayIndex> indexMapping;

    public TextureCollection() {
        Log.setLogSystem(null);
        this.textures = new ArrayList();
        this.fileNames = new HashMap();
        this.indexMapping = new ArrayList();
        this.textLoadData = new ArrayList();
    }

    public int addTextureQueue(String name) {
        if (name.length() == 0) {
            return -1;
        }
        Integer index = this.fileNames.get(name);
        if (index != null) {
            return index;
        }
        int size = this.textLoadData.size();
        this.fileNames.put(name, size);
        this.textLoadData.add(new TextureLoadObject(name));
        return size;
    }

    public int addTextureQueue(float[] data, int sx, int sy) {
        int size = this.textLoadData.size();
        TextureLoadObject tlo = new TextureLoadObject(new int[]{sx, sy}, data);
        this.textLoadData.add(tlo);
        return size;
    }

    public void uploadTextures() {
        int i = 0;
        while (i < this.textLoadData.size()) {
            ArrayIndex ai;
            String name = this.textLoadData.get((int)i).textFileName;
            if (name == null) {
                ai = new ArrayIndex();
                ai.index = this.textures.size();
                this.indexMapping.add(ai);
                InternalTextureLoader tl = InternalTextureLoader.get();
                int[] size = this.textLoadData.get((int)i).size;
                try {
                    this.textures.add(tl.createTexture(size[0], size[1], 9729));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FloatBuffer tex_data = BufferUtils.createFloatBuffer((int)(3 * this.textLoadData.get((int)i).size[0] * this.textLoadData.get((int)i).size[1]));
                tex_data.put(this.textLoadData.get((int)i).data);
                tex_data.position(0);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
                this.textures.get(this.textures.size() - 1).bind();
                GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)size[0], (int)size[1], (int)0, (int)6407, (int)5126, (FloatBuffer)tex_data);
            } else {
                try {
                    ai = new ArrayIndex();
                    ai.index = this.textures.size();
                    this.indexMapping.add(ai);
                    this.textures.add(TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)("icons/" + name + ".png")), (int)9729));
                    GL30.glGenerateMipmap((int)3553);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public int getSize() {
        return this.textLoadData.size();
    }

    public void bind_texture(int index) {
        this.textures.get(this.indexMapping.get((int)index).index).bind();
    }

    public void unbind_texture() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    private class ArrayIndex {
        public int index;

        private ArrayIndex() {
        }
    }

    private class TextureLoadObject {
        public String textFileName;
        public int[] size;
        public float[] data;

        public TextureLoadObject(String textFileName) {
            this.textFileName = textFileName;
        }

        public TextureLoadObject(int[] size, float[] data) {
            this.size = size;
            this.data = data;
        }
    }
}

