/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.util.ArrayList;
import renderer.CubicBSpline;
import renderer.TextureCollection;
import renderer.VBO;
import renderer.shader.ShaderCollection;

public class SplineCollection {
    private static final float BETA_OFFSET = 0.002f;
    private float beta = 1.0f;
    private static final int SPLINE_SIZE = 50;
    protected ArrayList<CubicBSpline> splines = new ArrayList();

    public void add2D(float[] points, TextureCollection textures, VBO vbo) {
        CubicBSpline toAdd = new CubicBSpline();
        toAdd.loadControlPoints2D(this.beta -= 0.002f, points, 50, textures, vbo);
        if (this.beta < 0.2f) {
            this.beta = 1.0f;
        }
        this.splines.add(toAdd);
    }

    public int drawAll(float[] viewMatrix, TextureCollection textures, ShaderCollection shaders, VBO vbo) {
        int j = 0;
        while (j < this.splines.size()) {
            this.splines.get(j).drawSpline(viewMatrix, textures, shaders, vbo, 1.0f);
            ++j;
        }
        return this.splines.size();
    }

    public void setSplineThickness(float thickness) {
        int j = 0;
        while (j < this.splines.size()) {
            this.splines.get(j).setSplineThickness(thickness);
            ++j;
        }
    }
}

