/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import com.infovis.callgraph.CallBackInterface;
import graph.ConnectionEdge;
import interaction.CollisionDetection;
import java.awt.Canvas;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import renderer.SplineCollectionSelectable;
import renderer.TextRenderer;
import renderer.TextureCollection;
import renderer.VBO;
import renderer.shader.ShaderCollection;
import tools.Matrix;

public class RenderThread
extends Thread {
    private final int CLICKTIMER = 250;
    private boolean running = true;
    private Canvas canvas;
    private boolean resized = false;
    private int sizeX;
    private int sizeY;
    private TextureCollection textures;
    private TextRenderer textRender;
    private boolean graphInitialized;
    private boolean splineInitialized;
    private float[] points;
    private String[] labels;
    private boolean[] isLeaf;
    private ArrayList<ConnectionEdge> connections;
    private ArrayList<ConnectionEdge> hConnections;
    private ShaderCollection shaders;
    private VBO vbo;
    private SplineCollectionSelectable splines;
    private int selection = -1;
    private CollisionDetection collDet;
    private Matrix viewMatrix = new Matrix();
    private float textSize = 0.12f;
    private boolean drawMixed = false;
    private boolean getTime;
    private long time;
    private CallBackInterface cbi;

    public RenderThread(Canvas canvas, int sizeX, int sizeY, CallBackInterface cbi) {
        this.canvas = canvas;
        this.graphInitialized = false;
        this.splineInitialized = false;
        canvas.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                RenderThread.this.resized = true;
            }
        });
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.points = new float[0];
        this.labels = new String[0];
        this.connections = new ArrayList();
        this.hConnections = new ArrayList();
        this.cbi = cbi;
    }

    private void init() {
        try {
            Display.setFullscreen((boolean)false);
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.sizeX, this.sizeY));
            Display.setParent((Canvas)this.canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        try {
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        this.shaders = new ShaderCollection();
        this.vbo = new VBO();
        this.textures = new TextureCollection();
        this.textRender = new TextRenderer("icons/font.png", this.textures, 0);
        this.textures.addTextureQueue("test");
        GL11.glViewport((int)0, (int)0, (int)this.sizeX, (int)this.sizeY);
        this.viewMatrix = new Matrix();
        this.viewMatrix.translate(new Vector2f(-0.9f, 1.05f));
        this.viewMatrix.scale(new Vector3f(1.5f, -2.0f, 1.0f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3154, (int)4354);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)1.75f);
    }

    private void loadSpline() {
        this.textures = new TextureCollection();
        this.textRender = new TextRenderer("icons/font.png", this.textures, 0);
        this.textures.addTextureQueue("test");
        this.splines = new SplineCollectionSelectable();
        int i = 0;
        while (i < this.connections.size()) {
            float[] line = this.connections.get((int)i).path;
            this.splines.add2D(this.connections.get((int)i).nodes, line, this.textures, this.vbo);
            ++i;
        }
        System.out.println("RenderThread: number of splines " + this.connections.size());
    }

    public void setGraph(float[] points, String[] labels, boolean[] isLeaf, ArrayList<ConnectionEdge> connections, ArrayList<ConnectionEdge> hConnections) {
        this.graphInitialized = true;
        this.splineInitialized = false;
        this.selection = -1;
        this.collDet = new CollisionDetection();
        this.time = System.currentTimeMillis();
        this.points = points;
        this.labels = labels;
        this.isLeaf = isLeaf;
        this.connections = connections;
        this.hConnections = hConnections;
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            if (this.resized) {
                this.sizeX = this.canvas.getSize().width;
                this.sizeY = this.canvas.getSize().height;
                GL11.glViewport((int)0, (int)0, (int)this.sizeX, (int)this.sizeY);
                this.resized = false;
            }
            if (this.graphInitialized && !this.splineInitialized) {
                this.loadSpline();
                this.textures.uploadTextures();
                this.splineInitialized = true;
            }
            float[] currentMatrix = this.viewMatrix.getMatrix();
            if (this.graphInitialized) {
                int count;
                GL11.glDisable((int)2929);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)1.0, (double)-1.0);
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                GL11.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glClear((int)16640);
                GL11.glColor3f((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex2f((float)1.0f, (float)1.0f);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)-1.0f, (float)1.0f);
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex2f((float)-1.0f, (float)-1.0f);
                GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                GL11.glVertex2f((float)1.0f, (float)-1.0f);
                GL11.glEnd();
                if (this.selection == -1) {
                    count = this.splines.drawAll(currentMatrix, this.textures, this.shaders, this.vbo);
                    this.cbi.setActiveEdgeCount(count);
                } else {
                    count = this.splines.drawAll(this.labels[this.selection], currentMatrix, this.textures, this.shaders, this.vbo);
                    this.cbi.setActiveEdgeCount(count);
                }
                int i = 0;
                while (i < this.hConnections.size()) {
                    float[] line = this.hConnections.get((int)i).path;
                    GL11.glDisable((int)3553);
                    int j = 0;
                    while (j < line.length - 2) {
                        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15f);
                        GL11.glBegin((int)1);
                        float[] pos = new float[]{line[j], line[j + 1]};
                        pos[0] = currentMatrix[0] * pos[0] + currentMatrix[3] + currentMatrix[0] * 0.005f;
                        pos[1] = currentMatrix[5] * pos[1] + currentMatrix[7];
                        float[] pos1 = new float[]{line[j + 2], line[j + 3]};
                        pos1[0] = currentMatrix[0] * pos1[0] + currentMatrix[3];
                        pos1[1] = currentMatrix[5] * pos1[1] + currentMatrix[7];
                        Vector2f vec = new Vector2f(pos1[0] - pos[0], pos1[1] - pos[1]);
                        vec.normalise();
                        vec.scale(0.05f);
                        pos[0] = pos[0] + vec.x;
                        pos[1] = pos[1] + vec.y;
                        GL11.glVertex2f((float)pos[0], (float)pos[1]);
                        GL11.glVertex2f((float)pos1[0], (float)pos1[1]);
                        GL11.glEnd();
                        j += 2;
                    }
                    ++i;
                }
                GL11.glEnable((int)3553);
                this.collDet.reset();
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
                i = 0;
                while (i < this.labels.length) {
                    float[] pos = new float[]{this.points[2 * i], this.points[2 * i + 1]};
                    pos[0] = currentMatrix[0] * pos[0] + currentMatrix[3];
                    pos[1] = currentMatrix[5] * pos[1] + currentMatrix[7];
                    this.collDet.addElement(new float[]{pos[0] + 0.005f, pos[1] - 0.013f, 0.09f, (float)this.sizeX / (float)this.sizeY * 0.022f});
                    if (i == this.selection) {
                        GL11.glColor3f((float)0.0f, (float)0.7f, (float)0.7f);
                    }
                    if (!this.drawMixed) {
                        this.textRender.draw_string(this.labels[i], pos[0] + 0.005f, pos[1] - 0.015f, this.textSize, (float)this.sizeY / (float)this.sizeX);
                    } else if (!this.isLeaf[i]) {
                        this.textRender.draw_string(this.labels[i], pos[0] + 0.005f, pos[1] - 0.015f, 0.2f, (float)this.sizeY / (float)this.sizeX);
                    } else {
                        this.textRender.draw_string(this.labels[i], pos[0] + 0.005f, pos[1] - 0.015f, 0.085f, (float)this.sizeY / (float)this.sizeX);
                    }
                    if (i == this.selection) {
                        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
                    }
                    ++i;
                }
            }
            if (Mouse.isButtonDown((int)0)) {
                if (!this.getTime) {
                    this.time = System.currentTimeMillis();
                    this.getTime = true;
                }
                float dx = Mouse.getDX();
                float dy = Mouse.getDY();
                this.viewMatrix.translate(new Vector2f(dx / 700.0f, -dy / 500.0f * -1.0f / this.viewMatrix.m11));
            } else {
                if (this.getTime && System.currentTimeMillis() - this.time < 250L) {
                    float x = (float)Mouse.getX() / (float)this.sizeX;
                    float y = (float)Mouse.getY() / (float)this.sizeY;
                    x = 2.0f * x - 1.0f;
                    y = 2.0f * y - 1.0f;
                    int newSelection = this.collDet.getCollisionIndex(new float[]{x, y}, new float[]{1.0f, 1.0f});
                    this.selection = newSelection != this.selection ? newSelection : -1;
                }
                this.getTime = false;
            }
            int dWheel = Mouse.getDWheel();
            if (dWheel != 0) {
                if (dWheel < 0) {
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, -0.5f));
                    this.viewMatrix = (Matrix)this.viewMatrix.scale(new Vector3f(1.0f, 1.1f, 1.0f));
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, 0.5f));
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, -0.09090912f));
                } else if (dWheel > 0) {
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, -0.5f));
                    this.viewMatrix = (Matrix)this.viewMatrix.scale(new Vector3f(1.0f, 0.9f, 1.0f));
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, 0.5f));
                    this.viewMatrix = (Matrix)this.viewMatrix.translate(new Vector2f(0.0f, 0.111111164f));
                }
            }
            Display.update();
        }
        Display.destroy();
    }

    public void terminate() {
        this.running = false;
    }

    public void setTextSize(float size) {
        this.textSize = size;
    }

    public void setDrawMixed(boolean isMixed) {
        this.drawMixed = isMixed;
    }

    public void setSplineThickness(float thickness) {
        this.splines.setSplineThickness(thickness);
    }

    public void setSplineContext(boolean context) {
        this.splines.setEnableContext(context);
    }
}

